function ConstructionSite:SetConstructionSiteEntity()
	local entity, cm1, cm2, cm3, cm4 = self:PickEntity()
	self:ChangeEntity(entity)
	AttachDoors(self, entity)
	
	if IsKindOf(self.building_class_proto, "SupplyRocketBuilding") and self:HasSpot("Rocket") then
		local e = GetConstructionRocketEntity()
		local a = PlaceObject("Shapeshifter")
		a:ChangeEntity(e)
		self:Attach(a, self:GetSpotBeginIndex("Rocket"))
		cm1, cm2, cm3, cm4 = DecodePalette(GetConstructableRocketPalette())
	end
	
	-- [ADDED PART]:start
	-- Permet de prendre en compte les nouvelles Rockets pour les afficher sur le site de construction
	if IsKindOf(self.building_class_proto, "RDM_SupplyRocketBuilding") and self:HasSpot("Rocket") then
		local e = self.building_class_proto.rocket_class
		local a = PlaceObject("Shapeshifter")
		a:ChangeEntity(e)
		self:Attach(a, self:GetSpotBeginIndex("Rocket"))
		cm1, cm2, cm3, cm4 = DecodePalette(GetConstructableRocketPalette())
	end
	-- [ADDED PART]:end
	
	if not cm1 then
		cm1, cm2, cm3, cm4 = GetBuildingColors(GetCurrentColonyColorScheme(), self.building_class_proto)
	end
	
	if cm1 then
		CreateGameTimeThread(Building.SetPalette, self, cm1, cm2, cm3, cm4)
	end
end